/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import twilightforest.TwilightForestMod;
import twilightforest.compat.TConCompat;
import twilightforest.compat.TrinketsCompat;

public abstract class TFCompat {
    public static final String TRINKETS_ID = "trinkets";
    public static final String IE_ID = "immersiveengineering";
    public static final String TCON_ID = "tconstruct";
    public static final String UNDERGARDEN_ID = "undergarden";
    public static HashMap<String, Class<? extends TFCompat>> classes = new HashMap();
    public static Set<TFCompat> modules = new HashSet<TFCompat>();
    public final String modName;
    private boolean isActivated = false;

    protected TFCompat(String modName) {
        this.modName = modName;
    }

    public static void preInitCompat() {
        for (Map.Entry<String, Class<? extends TFCompat>> entry : classes.entrySet()) {
            if (FabricLoader.getInstance().isModLoaded(entry.getKey())) {
                try {
                    TFCompat compat = entry.getValue().newInstance();
                    modules.add(compat);
                    compat.isActivated = compat.preInit();
                    if (compat.isActivated) {
                        TwilightForestMod.LOGGER.info("Loaded compatibility for mod {}.", (Object)compat.modName);
                        continue;
                    }
                    TwilightForestMod.LOGGER.warn("Couldn't activate compatibility for mod {}!", (Object)compat.modName);
                }
                catch (Exception e) {
                    TwilightForestMod.LOGGER.error("Had a {} error loading {} compatibility in preInit!", (Object)e.getLocalizedMessage(), (Object)entry.getKey());
                    TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
                }
                continue;
            }
            TwilightForestMod.LOGGER.info("Skipped compatibility for mod {}.", (Object)entry.getKey());
        }
    }

    public static void initCompat() {
        for (TFCompat compat : modules) {
            if (!compat.isActivated) continue;
            try {
                compat.init();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.error("Had a {} error loading {} compatibility in init!", (Object)e.getLocalizedMessage(), (Object)compat.modName);
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    public static void initCompatItems() {
        for (TFCompat compat : modules) {
            if (!compat.isActivated) continue;
            try {
                compat.initItems();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.error("Had a {} error loading {} compatibility in initializing items!", (Object)e.getLocalizedMessage(), (Object)compat.modName);
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    public static void postInitCompat() {
        for (TFCompat compat : modules) {
            if (!compat.isActivated) continue;
            try {
                compat.postInit();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.error("Had a {} error loading {} compatibility in postInit!", (Object)e.getLocalizedMessage(), (Object)compat.modName);
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    public static void sendIMCs() {
        for (TFCompat compat : modules) {
            if (!compat.isActivated) continue;
            try {
                compat.handleIMCs();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.error("Had a {} error loading {} compatibility in sending IMCs!", (Object)e.getLocalizedMessage(), (Object)compat.modName);
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    protected abstract boolean preInit();

    protected abstract void init();

    protected abstract void postInit();

    protected abstract void handleIMCs();

    protected abstract void initItems();

    static {
        classes.put(TRINKETS_ID, TrinketsCompat.class);
        classes.put(TCON_ID, TConCompat.class);
    }
}

